#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Hyperbolic Poincare transformedMod01.fsh  by   stb
//https://www.shadertoy.com/view/3lscDf
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
	Hyperbolic Poincaré transformed
	2015-2020 stb

	Just messing with some old code, and a few complex functions.
*/

// change these
const int N		= 7;	// number of polygon vertices
const int P		= 3;	// number of polygons meeting at a vertex
const int Iters	= 16;	// number of iterations


#define E 		2.71828182
#define HALFPI	1.57079633
#define PI		3.14159265
#define TWOPI	6.28318531

float s, c;
#define rotate(p, a) mat2(c=cos(a), s=-sin(a), -s, c) * p
#define rotate2(p, a) vec2(p.x*cos(a) - p.y*sin(a), p.x*sin(a) + p.y*cos(a))


vec2 radialRepeat(vec2 p, vec2 o, int n) {
    return rotate(vec2(o.x, o.y), floor(atan(p.x, p.y)*(float(n)/TWOPI)+.5)/(float(n)/TWOPI));
}

vec2 cInvert(vec2 p, vec2 o, float r) {
    return (p-o) * pow(r, 2.) / dot(p-o, p-o) + o;
}

vec2 cInvertMirror(vec2 p, vec2 o, float r, float flip){
    return (length(p-o)<r ^^ flip==1. ? cInvert(p, o, r) : p);
}

vec4 poincareGetStuff(int n_, int p_) {
    float n = PI / float(n_), p = PI / float(p_);
	vec2 r1 = vec2(cos(n), -sin(n));
    vec2 r2 = vec2(cos(p+n-HALFPI), -sin(p+n-HALFPI));
    float dist = (r1.x - (r2.x/r2.y) * r1.y);
    float rad = length(vec2(dist, 0.)-r1);
    float d2 = dist*dist - rad*rad;
    float s = (d2<0. ? 1. : sqrt(d2));
	return vec4(vec3(dist, rad, 1.)/s, float(d2<0.));
}

vec2 poincareCreateUVs(vec2 p, vec4 pI) {
    return cInvertMirror(p, radialRepeat(p, vec2(0., pI.x), N), pI.y, pI.w);
}

// Many complex functions are from: https://raw.githubusercontent.com/julesb/glsl-util/master/complexvisual.glsl

#ifndef sinh
	#define sinh(a) (pow(E, a)-pow(E, -a)) / 2.
#endif
#ifndef cosh
	#define cosh(a) (pow(E, a)+pow(E, -a)) / 2.
#endif

#define c_abs(a) length(a)
#define c_arg(a) atan(a.y, a.x)

#define c_conj(a) vec2(a.x, -a.y)
#define c_exp(a) vec2(exp(a.x)*cos(a.y), exp(a.x)*sin(a.y))
#define c_sqr(a) vec2(a.x*a.x-a.y*a.y, 2.*a.x*a.y)
#define c_mul(a, b) vec2(a.x*b.x-a.y*b.y, a.x*b.y+a.y*b.x)
#define c_div(a, b) vec2((a.x*b.x+a.y*b.y)/(b.x*b.x+b.y*b.y), (a.y*b.x-a.x*b.y)/(b.x*b.x+b.y*b.y))
#define c_sin(a) vec2(sin(a.x)*cosh(a.y), cos(a.x)*sinh(a.y))
#define c_cos(a) vec2(cos(a.x)*cosh(a.y), -sin(a.x)*sinh(a.y))
#define c_cartToPolar(a) vec2(length(a), atan(a.y, a.x))
#define c_polarToCart(a) a.x * vec2(cos(a.y), sin(a.y))

vec2 c_sqrt(vec2 a){
    float r = sqrt(a.x*a.x+a.y*a.y);
    float rpart = sqrt(.5*(r+a.x));
    float ipart = sqrt(.5*(r-a.x));
    if (a.y < 0.) ipart = -ipart;
    return vec2(rpart, ipart);
}

vec2 c_tan(vec2 a){ return c_div(c_sin(a), c_cos(a)); }

vec2 c_log(vec2 a){
    float rpart = length(a);
    float ipart = atan(a.y, a.x);
    if (ipart > PI) ipart -= 2. * PI;
    return vec2(log(rpart), ipart);
}

vec2 c_toThe(vec2 a, float b){ return c_exp(b*c_log(a)); }
vec2 c_toThe(vec2 a, vec2 b){ return c_exp(c_mul(b, c_log(a))); }

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 p = 2. * (fragCoord.xy-.5*iResolution.xy) / iResolution.y;
	
    
    // some transformations
    float nArms = 1.+floor(16.*abs(fract(.025*iTime)-.5));
	p = rotate2(p, .2*iTime);
    p /= dot(p, p);
    p = c_toThe(p, nArms);
    p.x += 1.;
    p = c_toThe(p, .5);
    p.x += .5;
    p /= dot(p, p);
    p.x -= 1.;
    p = rotate2(p, .1*iTime);
    
    
    // get data for the disk model
    vec4 pI = poincareGetStuff(N, P);
    
    // build the disk
    for(int i=0; i<Iters; i++)
        p = poincareCreateUVs(p, pI);
    
    // uncomment to mirror from disk's margin
    //p = cInvertMirror(p, vec2(0., 0.), 1., 1.);
    
    
    // this is the pattern for each polygon
    float f = 1. - dot(p, p) / pow(pI.z, 2.);
    
    fragColor = vec4(vec3(f)*vec3(1.7, 1.2, .8), 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

